//----------------------------------------------------------------------
//  TIM13 の Update event (UEV) 割込みを使って，
//  Ticker と同じような機能を持つクラス，ヘッダ
//
//  2020/01/25, Copyright (c) 2020 MIKAMI, Naoki
//----------------------------------------------------------------------

#include "mbed.h"

#ifndef MYTICKER13_F446_HPP
#define MYTICKER13_F446_HPP

namespace Mikami
{
    class MyTicker13
    {
    public:
        MyTicker13();
        // 割込みサービスルーチンの割り当てと割込み周期（μs 単位）の設定
        void Attach_us(void (*Func)(), uint16_t time);
        // 割込みサービスルーチンの割り当てと割込み周期（ms 単位）の設定
        void Attach_ms(void (*Func)(), uint16_t time);
        // 割込みを有効にする
        void Enable() { tim_->DIER |= TIM_DIER_UIE; }
        // 割込みを無効にする
        void Disable() { tim_->DIER &= ~TIM_DIER_UIE; }

    private:
        // 割込みサービス･ルーチンの中で実行される関数のポインタ
        static void (*fp)();
        // タイマに対応する構造体のポインタ
        static TIM_TypeDef* const tim_;
        static bool created_;
        uint32_t intClock_;     // TIM13 を駆動するクロック周波数

        // 割込みサービス･ルーチン
        static void Isr();
        // タイマ設定の共通の処理
        void SetCommon(void (*Func)());

        // コピー･コンストラクタおよび代入演算子の禁止のため
        MyTicker13(const MyTicker13& );
        MyTicker13& operator=(const MyTicker13& );
    };
}
#endif  // MYTICKER13_F446_HPP

