//----------------------------------------------------------------------
//  Ticker と同じような機能のほかに，割込みの時間間隔を設定するメンバ関数を
//  追加した行うクラス，ヘッダ
//
//  2020/02/22, Copyright (c) 2020 MIKAMI, Naoki
//----------------------------------------------------------------------

#include "mbed.h"

#ifndef MYTICKER14_F446_HPP
#define MYTICKER14_F446_HPP

namespace Mikami
{
    class MyTicker14
    {
    public:
        MyTicker14();
        // 割込みサービスルーチンの割り当てと割込み周期（μs 単位）の設定
        void Attach_us(void (*Func)(), uint16_t time);
        // 割込みサービスルーチンの割り当てと割込み周期（ms 単位）の設定
        void Attach_ms(void (*Func)(), uint16_t time);
        // 割込みを有効にする
        void Enable() { tim_->DIER |= TIM_DIER_UIE; }
        // 割込みを無効にする
        void Disable() { tim_->DIER &= ~TIM_DIER_UIE; }
        // 割込み周期（μs 単位）の設定
        void SetPeriod_us(uint16_t time);
        // 割込み周期（ms 単位）の設定
        void SetPeriod_ms(uint16_t time);

    private:
        // 割込みサービス･ルーチンの中で実行される関数のポインタ
        static void (*fp_)();
        // タイマに対応する構造体のポインタ
        static TIM_TypeDef* const tim_;
        static bool created_;
        uint32_t intClock_;     // TIM14 を駆動するクロック周波数

        // 割込みサービス･ルーチン
        static void Isr();
        // タイマ設定の共通の処理
        void SetCommon(void (*Func)());

        // コピー･コンストラクタおよび代入演算子の禁止のため
        MyTicker14(const MyTicker14& );
        MyTicker14& operator=(const MyTicker14& );
    };
}
#endif  // MYTICKER14_F446_HPP

