//--------------------------------------------------------
//  STM32F446 内蔵の DAC 用のクラス
//      出力端子：   A2  (PA_4)
//
//  2020/02/18, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------

#include "F446_Dac.hpp"

namespace Mikami
{
    // コンストラクタ， A2 に接続される CH1 のみを有効にする
    DacF446::DacF446() : myDac_(DAC)
    {
        SetGPIO();                  // GPIO の設定

        __HAL_RCC_DAC_CLK_ENABLE(); // DAC にクロックを供給する
        // __HAL_RCC_DAC_CLK_ENABLE() の定義：stm32f4xx_hal_rcc_ex.h
 
        myDac_->CR = DAC_CR_EN1;
    }

    // DA 変換器に関係のある GPIO の設定
    void DacF446::SetGPIO()
    {
        static const PinName PIN = A2;
        // 各シンボルは stm32f4xx_hal_gpio.h で定義されている
        // MODIFY_REG() マクロは stm32f4xx.h で定義されている
        uint32_t nShift = STM_PIN(PIN) << 1;
        uint32_t moder = GPIO_MODE_ANALOG << nShift;
        uint32_t mask = 0x03 << nShift;

        if (__HAL_RCC_GPIOA_IS_CLK_DISABLED())
            __HAL_RCC_GPIOA_CLK_ENABLE();       // GPIOA にクロックを供給
        MODIFY_REG(GPIOA->MODER, mask, moder);  // GPIOA のピンを設定
    }
}

