//-------------------------------------------------------------
//  F446 内蔵 ADC2 をポーリング方式で使うための派生クラス
//      基底クラス： AdcF446_Base
//
//  2020/02/23, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "F446_AdcBase.hpp"

#ifndef ADC_F446_POLLING_HPP
#define ADC_F446_POLLING_HPP

namespace Mikami
{
    class AdcF446_Polling : public AdcF446_Base
    {
    public:
        // コンストラクタ
        //      fSampling 標本化周波数 [kHz]
        //      pin     入力ピンの名前
        AdcF446_Polling(float fSampling, PinName pin)
            : AdcF446_Base(fSampling, pin) {}

        virtual ~AdcF446_Polling() {}

        // AD 変換された値を読み込む
        //      -1.0f <= AD変換された値 < 1.0f
        virtual float Read() const
        {
            while ((myAdc_->SR & ADC_SR_EOC) != ADC_SR_EOC) {}
            return ToFloat(myAdc_->DR);
        }
    };
}
#endif  // ADC_F446_POLLING_HPP

