//-------------------------------------------------------------
//  F446 内蔵 ADC2 を割込み方式で使うための派生クラス
//      基底クラス： AdcF446_Base
//
//  2020/02/23, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "F446_AdcBase.hpp"

#ifndef ADC_F446_INTERRUPT_HPP
#define ADC_F446_INTERRUPT_HPP

namespace Mikami
{
    class AdcF446_Intr : public AdcF446_Base
    {
    public:
        // コンストラクタ
        //      fSampling 標本化周波数 [kHz]
        //      pin     入力ピンの名前
        AdcF446_Intr(float fSampling, PinName pin)
            : AdcF446_Base(fSampling, pin)
        {   myAdc_->CR1 |= ADC_CR1_EOCIE; }     // AD 変換終了割り込みを許可

        virtual ~AdcF446_Intr() {}

        // 割込みベクタの設定と AD 変換割込みを有効にする
        void SetIntrVec(void (*Func)())
        {
            fp_ = Func;         // 引数として渡された処理を割り当てる
            NVIC_SetVector(ADC_IRQn, (uint32_t)Isr);    // "core_cm4.h" 参照
            NVIC_EnableIRQ(ADC_IRQn);                   // "core_cm4.h" 参照
        }    

        // AD 変換された値を読み込む
        //      -1.0f <= AD変換された値 < 1.0f
        virtual float Read() const { return ToFloat(myAdc_->DR); }

    private:
        static void (*fp_)();   // 割込みサービス･ルーチンの中で実行される関数のポインタ

        // 割込みサービス･ルーチン，このクラスで使っている ADC であることを確認
        static void Isr()
        {   if ((myAdc_->SR & ADC_SR_EOC_Msk) == ADC_SR_EOC) fp_(); }
    };

    // static メンバの実体
    void (*AdcF446_Intr::fp_)();
}
#endif  // ADC_F446_INTERRUPT_HPP

