//-----------------------------------------------------------
//  周波数応答を定義するクラスの基底クラスとして使う抽象クラス   
//      周波数特性を描画するために与える周波数応答は，FrqRespDrawer
//      クラスのメンバ関数 DrawGraph() の第一引数で与える．
//      その周波数応答は，このクラスを継承する派生クラスで，純粋仮想 
//      関数 AbsH_z() をオーバーライドする関数として定義すること．
//
//  FrequencyResponse class (abstract base class)
//      Derived class of this class must be used to give
//      the first argument of FrqRespDrawer::DrawGraph().
//      AbsH_z() must be overrided in the derived class
//
//  2016/11/08, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef FREQUENCY_RESPONSE_BASE_HPP
#define FREQUENCY_RESPONSE_BASE_HPP

#include <complex>  // requisite for complex

namespace Mikami
{
    typedef complex<float> Complex; // define "Complex"

    class FrequencyResponse
    {
    public:
        // 周波数応答の絶対値を返す関数, 引数: z^(-1)
        virtual float AbsH_z(Complex u) = 0;
    };
}
#endif  // F746_FREQUENCY_RESPONSE_BASE_HPP
