//-----------------------------------------------------------
//  SiaIO class for output
//  2016/02/16, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------

#include "sai_io_o.hpp"

namespace Mikami
{
    SaiIO_O::SaiIO_O(int size, int fs) : FS_(fs), tmpIndex_(0)
    {
        nData_ = size;
        bufferSize_ = (size*2)*2;
        outBuffer_ = new int16_t[bufferSize_];
        tmp_ = new int16_t[size*2];
        ClearOutBuffer();
        xferred_ = false;
    }

    void SaiIO_O::InitCodecOut()
    {
        if (BSP_AUDIO_OUT_Init(OUTPUT_DEVICE_HEADPHONE, VOLUME_OUT_, FS_) == AUDIO_ERROR)
            ErrorTrap();

        NVIC_SetVector(AUDIO_OUT_SAIx_DMAx_IRQ, (uint32_t)AUDIO_OUT_SAIx_DMAx_IRQHandler);
        BSP_AUDIO_OUT_SetAudioFrameSlot(CODEC_AUDIOFRAME_SLOT_02);

        if (BSP_AUDIO_OUT_Play((uint16_t *)outBuffer_,
                               bufferSize_*AUDIODATA_SIZE) == AUDIO_ERROR)
            ErrorTrap();
    }

    bool SaiIO_O::IsXferred()
    {
        if (xferred_)
        {
            tmpIndex_ = 0;
            return true;
        }
        else
            return false;
    }

    void SaiIO_O::Output(int16_t xL, int16_t xR)
    {
        tmp_[tmpIndex_++] = xL; // Left
        tmp_[tmpIndex_++] = xR; // Right
    }
    
    void SaiIO_O::ClearOutBuffer()
    {
        for (int n=0; n<bufferSize_; n++)   outBuffer_[n] = 0;
        for (int n=0; n<bufferSize_/2; n++) tmp_[n] = 0;
    }

    void SaiIO_O::StartOutPlay()
    {
        if (BSP_AUDIO_OUT_Play((uint16_t *)outBuffer_,
                               bufferSize_*AUDIODATA_SIZE) == AUDIO_ERROR)
            ErrorTrap();
    }
    
    void SaiIO_O::StopOutPlay()
    {
        if (BSP_AUDIO_OUT_Stop(CODEC_PDWN_SW))
                        ErrorTrap();
    }
    
    void SaiIO_O::ErrorTrap()
    {
        DigitalOut led1(LED1);
        fprintf(stderr, "\r\n### ERROR\r\n");
        while(true)
        {
            led1 = !led1;
            wait_ms(250);
        }
    }

    void SaiIO_O::FillBuffer(uint32_t offset)
    {
        int k = offset;
        for (int n=0; n<nData_*2; n++)
             outBuffer_[k++] = tmp_[n];
        xferred_ = true;
    }

    // Instances for static variables
    int32_t SaiIO_O::nData_;
    int32_t SaiIO_O::bufferSize_;
    int16_t* SaiIO_O::outBuffer_;
    int16_t* SaiIO_O::tmp_;       
    __IO bool SaiIO_O::xferred_;
}

