//------------------------------------------------------------------------------
//  声帯波の合成 ― Rosenberg 波（ヘッダ）
//      作成者：三上直樹，2013/10/27 作成，(c)三上直樹 2013
//------------------------------------------------------------------------------

#ifndef ROSENBERG_HPP
#define ROSENBERGL_HPP

class Rosenberg
{
private:
    const float dt_;

    float period_, t1_, t2_, t_, amp_;

    // コピー･コンストラクタの使用禁止
    Rosenberg(const Rosenberg& g);
    // 代入演算子の使用禁止
    Rosenberg& operator=(const Rosenberg& g);

public:
    // 初期化を行うコンストラクタ
    //      f0: 基本周波数
    //      fs: 標本化周波数
    //      amp: 振幅
    Rosenberg(float f0, float fs, float amp)
        : dt_(1.0f/fs), t_(0), amp_(amp)
    { SetPeriod(f0); }

    // 基本周期の再設定
    //      f0: 基本周波数   
    void SetPeriod(float f0);

    // 振幅の再設定
    void SetAmplitude(float amp) { amp_ = amp; }

    // t_ = 0 に設定
    void Reset() { t_ = 0; }

    // Rosengerg 波の計算
    float Execute();
};

#endif  // ROSENBERG_HPP
