//------------------------------------------------------------------------------
//  声帯波の合成 ― Rosenberg 波
//      作成者：三上直樹，2013/10/27 作成，(c)三上直樹 2013
//------------------------------------------------------------------------------

#include "Rosenberg.hpp"

    // 基本周期の設定
    void Rosenberg::SetPeriod(float f0)
    {
        period_ = 1.0f/f0;
        t1_ = 0.4f/f0;
        t2_ = 0.16f/f0;
    }

    // Rosengerg 波の計算
    float Rosenberg::Execute()
    {
        float g = 0;

        if (t_ < t1_)
        {
            float x = t_/t1_;
            g = amp_*(3.0f - 2.0f*x)*x*x;
        }
        if ((t_ >= t1_) && (t_ < t1_+t2_))
        {
            float x = (t_ - t1_)/t2_;
            g = amp_*(1.0f - x*x);
        }

        if ((t_+=dt_) > period_) t_ -= period_;

        return g;
    }

