//------------------------------------------------------------------------------
//  音声合成で使う共振器（ヘッダ）
//      作成者：三上直樹，2013/11/27 作成，(c)三上直樹 2013
//------------------------------------------------------------------------------

#include "mbed.h"

#ifndef RESONATOR_HPP
#define RESONATOR_HPP

class Resonator
{
private:
    static float piT_;
    float a1_, a2_, b0_;
    float yn1_, yn2_;

    // コンストラクタに共通な初期化
    void Initialize(float fr, float bw, float fs);

public:
    // 共振周波数と帯域幅に対応する構造体
    struct FrBw { float fr, bw; };

    // デフォルト･コンストラクタ
    Resonator() {}

    // 初期化を行うコンストラクタ
    Resonator(float fr, float bw, float fs) { Initialize(fr, bw, fs); }

    // 初期化を行うコンストラクタ（構造体使用）
    Resonator(FrBw fb, float fs) { Initialize(fb.fr, fb.bw, fs); }

    // 共振器のパラメータの設定
    void Set(float fr, float bw);

    // 共振器のパラメータの設定（構造体使用）
    void Set(FrBw fb) { Set(fb.fr, fb.bw); }

    // 内部の遅延器をクリア
    void Clear() { yn1_ = 0; yn2_ = 0; }

    // 共振器に対応する処理の実行
    float Execute(float xin);
};

#endif  // RESONATOR_HPP
