//--------------------------------------------------------------
//  Overwrite functuions and define calback functions
//  for functions in stm32746g_discovery_audio.cpp
//--------------------------------------------------------------
#include "BSP_AudioOut_Overwrite.hpp"

// These three callback functions are modyfied by Mikami
void BSP_AUDIO_OUT_HalfTransfer_CallBack()
{
    Mikami::SaiIO_O::FillBuffer1st();
}

void BSP_AUDIO_OUT_TransferComplete_CallBack()
{
    Mikami::SaiIO_O::FillBuffer2nd();
}

void BSP_AUDIO_OUT_Error_CallBack()
{
    Mikami::SaiIO_O::ErrorTrap();
}

//--------------------------------------------------------------
//  Followings are original by Nanase
//--------------------------------------------------------------

DMA_HandleTypeDef hdma_sai_tx;

void AUDIO_OUT_SAIx_DMAx_IRQHandler()
{
    HAL_DMA_IRQHandler(&hdma_sai_tx);
}

void BSP_AUDIO_OUT_MspInit(SAI_HandleTypeDef *hsai, void *Params)
{
    //static DMA_HandleTypeDef hdma_sai_tx;
    GPIO_InitTypeDef  gpio_init_structure;

    /* Enable SAI clock */
    AUDIO_OUT_SAIx_CLK_ENABLE();

    /* Enable GPIO clock */
    AUDIO_OUT_SAIx_MCLK_ENABLE();
    AUDIO_OUT_SAIx_SCK_SD_ENABLE();
    AUDIO_OUT_SAIx_FS_ENABLE();

    /* CODEC_SAI pins configuration: FS, SCK, MCK and SD pins ------------------*/
    gpio_init_structure.Pin = AUDIO_OUT_SAIx_FS_PIN;
    gpio_init_structure.Mode = GPIO_MODE_AF_PP;
    gpio_init_structure.Pull = GPIO_NOPULL;
    gpio_init_structure.Speed = GPIO_SPEED_HIGH;
    gpio_init_structure.Alternate = AUDIO_OUT_SAIx_FS_SD_MCLK_AF;
    HAL_GPIO_Init(AUDIO_OUT_SAIx_FS_GPIO_PORT, &gpio_init_structure);

    gpio_init_structure.Pin = AUDIO_OUT_SAIx_SCK_PIN;
    gpio_init_structure.Mode = GPIO_MODE_AF_PP;
    gpio_init_structure.Pull = GPIO_NOPULL;
    gpio_init_structure.Speed = GPIO_SPEED_HIGH;
    gpio_init_structure.Alternate = AUDIO_OUT_SAIx_SCK_AF;
    HAL_GPIO_Init(AUDIO_OUT_SAIx_SCK_SD_GPIO_PORT, &gpio_init_structure);

    gpio_init_structure.Pin =  AUDIO_OUT_SAIx_SD_PIN;
    gpio_init_structure.Mode = GPIO_MODE_AF_PP;
    gpio_init_structure.Pull = GPIO_NOPULL;
    gpio_init_structure.Speed = GPIO_SPEED_HIGH;
    gpio_init_structure.Alternate = AUDIO_OUT_SAIx_FS_SD_MCLK_AF;
    HAL_GPIO_Init(AUDIO_OUT_SAIx_SCK_SD_GPIO_PORT, &gpio_init_structure);

    gpio_init_structure.Pin = AUDIO_OUT_SAIx_MCLK_PIN;
    gpio_init_structure.Mode = GPIO_MODE_AF_PP;
    gpio_init_structure.Pull = GPIO_NOPULL;
    gpio_init_structure.Speed = GPIO_SPEED_HIGH;
    gpio_init_structure.Alternate = AUDIO_OUT_SAIx_FS_SD_MCLK_AF;
    HAL_GPIO_Init(AUDIO_OUT_SAIx_MCLK_GPIO_PORT, &gpio_init_structure);

    /* Enable the DMA clock */
    AUDIO_OUT_SAIx_DMAx_CLK_ENABLE();

    if(hsai->Instance == AUDIO_OUT_SAIx)
    {
        /* Configure the hdma_saiTx handle parameters */
        hdma_sai_tx.Init.Channel             = AUDIO_OUT_SAIx_DMAx_CHANNEL;
        hdma_sai_tx.Init.Direction           = DMA_MEMORY_TO_PERIPH;
        hdma_sai_tx.Init.PeriphInc           = DMA_PINC_DISABLE;
        hdma_sai_tx.Init.MemInc              = DMA_MINC_ENABLE;
        hdma_sai_tx.Init.PeriphDataAlignment = AUDIO_OUT_SAIx_DMAx_PERIPH_DATA_SIZE;
        hdma_sai_tx.Init.MemDataAlignment    = AUDIO_OUT_SAIx_DMAx_MEM_DATA_SIZE;
        hdma_sai_tx.Init.Mode                = DMA_CIRCULAR;
        hdma_sai_tx.Init.Priority            = DMA_PRIORITY_HIGH;
        hdma_sai_tx.Init.FIFOMode            = DMA_FIFOMODE_ENABLE;
        hdma_sai_tx.Init.FIFOThreshold       = DMA_FIFO_THRESHOLD_FULL;
        hdma_sai_tx.Init.MemBurst            = DMA_MBURST_SINGLE;
        hdma_sai_tx.Init.PeriphBurst         = DMA_PBURST_SINGLE;

        hdma_sai_tx.Instance = AUDIO_OUT_SAIx_DMAx_STREAM;

        /* Associate the DMA handle */
        __HAL_LINKDMA(hsai, hdmatx, hdma_sai_tx);

        /* Deinitialize the Stream for new transfer */
        HAL_DMA_DeInit(&hdma_sai_tx);

        /* Configure the DMA Stream */
        HAL_DMA_Init(&hdma_sai_tx);
    }
    
    /* SAI DMA IRQ Channel configuration */
    HAL_NVIC_SetPriority(AUDIO_OUT_SAIx_DMAx_IRQ, AUDIO_OUT_IRQ_PREPRIO, 0);
    HAL_NVIC_EnableIRQ(AUDIO_OUT_SAIx_DMAx_IRQ);
}


