//-----------------------------------------------------------
//  Function for waveform display
//
//  2015/10/26, Copyright (c) 2015 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef F746_WAVEFORM_DISPLAY_HPP
#define F746_WAVEFORM_DISPLAY_HPP

#include "mbed.h"

namespace Mikami
{
    void WaveformDisplay(LCD_DISCO_F746NG &lcd, uint16_t x0, uint16_t y0,
                         int16_t xn[], int nData, uint32_t backColor)
    {
        lcd.SetTextColor(backColor);
        lcd.FillRect(x0, y0-32, nData, 64);

        lcd.SetTextColor(LCD_COLOR_BLUE);
        lcd.DrawLine(x0-5, y0, x0+nData+5, y0);
        
        lcd.SetTextColor(LCD_COLOR_CYAN);
        uint16_t x1 = x0;
        uint16_t y1 = y0 - (xn[0] >> 9);
        for (int n=1; n<nData; n++)
        {
            uint16_t x2 = x0 + n;
            uint16_t y2 = y0 - (xn[n] >> 9);
            lcd.DrawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
    }
}
#endif  // F746_WAVEFORM_DISPLAY_HPP