//-----------------------------------------------------------
//  Demo waveform and spectrum display
//      Tap the screen to begin the spectrum analyzer 
//  No photo version of "F746_SpectralAnalysis_Example"
//
//  2015/11/24, Copyright (c) 2015 MIKAMI, Naoki
//-----------------------------------------------------------

#include "vowel_data.hpp"
#include "button_group.hpp"
#include "waveform_display.hpp"
#include "FFT_Analysis.hpp"
#include "SpectrumDisplay.hpp"
#include "LPC_Analysis.hpp"

using namespace Mikami;

const int N_FFT_ = 512;     // number of date for FFT
const int X0_ = 50;         // Origin for x axis
const int Y0_ = 236;        // Origin for y axis
const float DB1_ = 2.4f;    // Pixels for 1 dB
const int BIN_ = 1;         // Pixels per bin
const int W_DB = 60;        // Width in dB to be displayed

const int FS_ = 8000;       // Sampling frequency: 8 kHz

LCD_DISCO_F746NG lcd_;
TS_DISCO_F746NG ts_;

FftAnalyzer fft_(N_DATA_, N_FFT_);      // using FFT
LpcAnalyzer lpc_(N_DATA_, 10, N_FFT_);  // using linear prediction

int main()
{
    int16_t sn[N_DATA_];
    float sn_f[N_DATA_];
    float db1[N_FFT_/2+1];  // Log powerspectrum using FFT
    float db2[N_FFT_/2+1];  // Log powerspectrum using linear prediction

    uint32_t backColor = 0xFF006A6C;            // teal green
    lcd_.Clear(backColor);

    const string AIUEO[5] = {"/a/", "/i/", "/u/", "/e/", "/o/"};
    ButtonGroup aiueo(lcd_, ts_, 430, 15, 50, 40,
                      LCD_COLOR_BLUE, backColor,
                      5, AIUEO, 0, 10, 1, Font16);

    const string METHOD[3] = {"FFT (Bar)", "FFT (Line)", "LP"};
    ButtonGroup method(lcd_, ts_, 340, 15, 80, 40,
                       LCD_COLOR_BLUE, backColor,
                       3, METHOD, 0, 10, 1, Font12);
    uint32_t inActive = backColor & 0xD0FFFFFF;
    for (int n=0; n<3; n++) method.Draw(n, inActive, LCD_COLOR_LIGHTGRAY);

    SpectrumDisplay disp(lcd_, N_FFT_, X0_, Y0_, DB1_, BIN_, W_DB, FS_);
    bool dataOk = false;
    while (true)
    {
        int vowel;
        if (aiueo.GetTouchedNumber(vowel, 0xFF0000B0))
        {
            for (int n=0; n<N_DATA_; n++) sn[n] = sn_[vowel][n];
                WaveformDisplay(lcd_, 50, 40, sn, N_DATA_, backColor);

            for (int n=0; n<N_DATA_; n++) sn_f[n] = sn[n];
            fft_.Execute(sn_f, db1);
            lpc_.Execute(sn_f, db2);
            dataOk = true;
            disp.Clear(backColor);
            for (int n=0; n<3; n++) method.Redraw(n);
        }

        if (dataOk)
        {
            int k;
            if (method.GetTouchedNumber(k, 0xFF0000B0))
            {
                switch (k)
                {
                    case 0: disp.BarChart(db1, backColor);
                            break;
                    case 1: disp.LineChart(db1, backColor);
                            break;
                    case 2: disp.LineChart(db2, backColor);
                            break;
                }   
            }
        }
        wait(0.1);
    }
}
