//-------------------------------------------------------
// Class for display spectrum
// Copyright (c) 2015 MIKAMI, Naoki,  2015/10/26
//-------------------------------------------------------

#ifndef SPECTRUM_DISPLAY_HPP
#define SPECTRUM_DISPLAY_HPP

#include "LCD_DISCO_F746NG.h"

namespace Mikami
{
    class SpectrumDisplay
    {
    public:
        SpectrumDisplay(LCD_DISCO_F746NG &lcd,
                        int nFft, int x0, int y0,
                        float db1, int bin, float maxDb, int fs);
        void BarChart(float db[], uint32_t backColor);
        void LineChart(float db[], uint32_t backColor);
        void Clear(uint32_t backColor);

    private:
        const int N_FFT_;       // number of date for FFT
        const int X0_;          // Origin for x axis
        const int Y0_;          // Origin for y axis
        const float DB1_;       // Pixels for 1 dB
        const int BIN_;         // Pixels per bin
        const float MAX_DB_;    // Maximum dB
        const int FS_;          // Sampling frequency: 10 kHz

        LCD_DISCO_F746NG *const LCD_;

        void AxisX();       // x-axis
        void AxisY();       // y-axis
    };
}
#endif  // SPECTRUM_DISPLAY_HPP
