//-------------------------------------------------------
// Class for spectrum analysis using FFT (Header)
// Copyright (c) 2015 MIKAMI, Naoki,  2015/10/26
//-------------------------------------------------------

#ifndef FFT_ANALYZER_HPP
#define FFT_ANALYZER_HPP

#include "fftReal.hpp"
#include "Hamming.hpp"

namespace Mikami
{
    class FftAnalyzer
    {
    public:
        FftAnalyzer(int nData, int nFft);
        ~FftAnalyzer();
        void Execute(float xn[], float db[]);

    private:
        const int N_DATA_;
        const int N_FFT_;

        HammingWindow hm_;
        FftReal fft_;

        float* xData;   // Data to be analyzed
        float* xFft;    // Input for FFT
        Complex* yFft;  // Output of FFT
        float* normY;   // Powerspectrum

        float Sqr(float x) { return x*x; }
    };
}

#endif  // FFT_ANALYZER_HPP

