//-------------------------------------------------------
// Class for spectrum analysis using FFT
// Copyright (c) 2015 MIKAMI, Naoki,  2015/10/26
//-------------------------------------------------------

#include "FFT_Analysis.hpp"

namespace Mikami
{
    FftAnalyzer::FftAnalyzer(int nData, int nFft)
            : N_DATA_(nData), N_FFT_(nFft),
              hm_(nData-1, nFft), fft_(nFft)
    {
        xData = new float[nData];       // Data to be analyzed
        xFft = new float[nFft];         // Input for FFT
        yFft = new Complex[nFft/2+1];   // Output of FFT
        normY = new float[nFft/2+1];    // Powerspectrum
    }
   
    FftAnalyzer::~FftAnalyzer()
    {
        delete[] xData;
        delete[] xFft;
        delete[] yFft;
        delete[] normY;
    }

    void FftAnalyzer::Execute(float xn[], float db[])
    {
        // Differencing
        for (int n=0; n<N_DATA_-1; n++)
            xData[n] = xn[n+1] - xn[n];

        hm_.Execute(xData, xFft);    // Windowing and zero-padding
        fft_.Execute(xFft, yFft);    // Execute FFT

        // Squared magnitude
        for (int n=0; n<=N_FFT_/2; n++)
            normY[n] = Sqr(yFft[n].real()) + Sqr(yFft[n].imag());
            
        // Search maximum
        float max = 0;
        for (int n=0; n<=N_FFT_/2; n++)
            max = (max > normY[n]) ? max : normY[n];
        float invMax = 1.0f/max;

        // Translate to dB
        for (int n=0; n<=N_FFT_/2; n++)
            db[n] = 10.0f*log10f(invMax*normY[n]);
    }
}


