//---------------------------------------------------------------
//  トリガの条件を満足する点を探す
//
//  2017/07/24, Copyright (c) 2017 MIKAMI, Naoki
//---------------------------------------------------------------

#ifndef F746_TRIGGER_HPP
#define F746_TRIGGER_HPP

#include "mbed.h"
#include "Array.hpp"

namespace Mikami
{
    int Trigger(const Array<int16_t>& xn,   // 対象とするデータ
                int th)                     // トリガの基準値
    {
        int n;
        for (n=1; n<xn.Length()/2; n++)
            if ((xn[n-1] < -th) && (xn[n] > th))
                return n;
        return 0;
    }
}
#endif  // F746_TRIGGER_HPP
