//-----------------------------------------------------------------
//  正弦波＋ノイズの発生器（標本化周波数：48 kHz）
//      ノイズの大きさは SeekBar で変えられる
//
//  使用しているライブラリのリビジョン：
//          F746_GUI            Rev.33
//          F746_SAI_IO         Rev.12
//          mbed                Rev.170
//
//  2018/11/04, Copyright (c) 2018 MIKAMI, Naoki
//-----------------------------------------------------------------

#include "SAI_InOut.hpp"
#include "LcdPanelFrq.hpp"
#include "GaussRand.hpp"

int main()
{
    const int FS = I2S_AUDIOFREQ_48K;       // 標本化周波数：48 kHz
    SaiIO mySai(SaiIO::OUTPUT, 2048, FS);   // オーディオ信号出力用
    LcdPanel myPanel(1.0f/(float)FS);       // LCD パネル表示用
    GaussRand rnd(0.5f, 0);                 // ガウス性ノイズ発生器

    mySai.PlayOut();    // オーディオ信号出力開始

    const float MAX_AMP = 8192.0f;
    while (true)        // 無限ループ
    {
        // 出力バッファへの転送が完了したら以下の処理を行う
        if (mySai.IsXferred())
        {
            for (int n=0; n<mySai.GetLength(); n++)
            {
                // 入力信号の生成
                float phi = myPanel.GetPhi();
                float sn = sinf(phi); // 入力信号となる正弦波を発生
                float noize = myPanel.GetNoiseLevel()*rnd.Next();

                int16_t xn = (int16_t)(MAX_AMP*sn);
                int16_t yn = (int16_t)(MAX_AMP*(sn + noize));
                mySai.Output(xn, yn);       // xn：ノイズなし（左チャンネル）
                                            // yn：ノイズ付加（右チャンネル）
                myPanel.Store(yn, n);       // 表示用として格納
            }

            myPanel.Display();  // 入出力信号の波形表示
        }
        myPanel.Update();   // パネルの状態を読み取り必要なパラメータなどを更新する
    }
}
