//------------------------------------------------------------------------------
//  イコライザ用フィルタのパラメータを設定し，その周波数特性を描画するためのクラス -- Header
//  
//  2016/04/10, Copyright (c) 2017 MIKAMI, Naoki
//------------------------------------------------------------------------------

#ifndef F746_GREQ_DISIGNER_AND_DRAWER_HPP
#define F746_GREQ_DISIGNER_AND_DRAWER_HPP

#include "NumericLabel.hpp"
#include "FrquencyResponseDrawer.hpp"
#include "GrEqParamsCalculator.hpp"
#include "GrEqualizerFrqResp.hpp"

namespace Mikami
{
    class GrEqDesignerDrawer
    {
    public:
        // Constructor
        GrEqDesignerDrawer(uint16_t x0, uint16_t y0, float db1,
                           int bands, float f0, int fs);

        virtual ~GrEqDesignerDrawer() {};

        // 周波数特性の描画
        void DrawResponse();

        // 周波数特性の平坦化と描画
        void DrawFlat();

        // 特定のバンドのイコライザ用フィルタのパラメータの設定と周波数特性の再描画
        void DesignAndRedraw(float gainDb, int n);

        BiquadGrEq::Coefs GetCoefficient(int n) { return ck_[n]; }

        uint16_t GetX0()
        {   return drawerObj_.X(f0_[0]); }
        
        uint16_t GetSpaceX()
        {   return (uint16_t)(drawerObj_.X(f0_[1])
                            - drawerObj_.X(f0_[0])); }

        int GetBands() { return BANDS_; }

    private:
        const uint16_t X0_, Y0_;
        const int BANDS_;
        const float Q_VAL_;

        Array<float> f0_;   // 中心周波数を格納する配列のポインタ
        Array<BiquadGrEq::Coefs> ck_;   // フィルタの係数
        GrEqParams calculator_;
        GrEqualizerFrqResp frqResp_;    // フィルタの周波数応答に対応するオブジェクト
        FrqRespDrawer drawerObj_;
    };
}
#endif  // F746_GREQ_DISIGNER_AND_DRAWER_HPP
