//------------------------------------------------------------------------------
//  イコライザ用フィルタのパラメータを設定し，その周波数特性を描画するためのクラス
//  
//  2017/04/10, Copyright (c) 2017 MIKAMI, Naoki
//------------------------------------------------------------------------------

#include "GrEqDesignerDrawer.hpp"

namespace Mikami
{
    // Constructor
    GrEqDesignerDrawer::GrEqDesignerDrawer(uint16_t x0, uint16_t y0, float db1,
                                           int bands, float f0, int fs)
        : X0_(x0), Y0_(y0), BANDS_(bands), Q_VAL_(1.0f/sqrtf(2.0f)),
          f0_(bands), ck_(bands),
          calculator_(bands, fs), frqResp_(bands),
          drawerObj_(x0, 50.0f, 20000.0f, 128, y0, -18, 18, db1, 6, fs)
    {
        for (int n=0; n<bands; n++) f0_[n] = f0*powf(2, n);

        for (int n=0; n<bands; n++)
            ck_[n] = calculator_.Execute(n, f0_[n], 0, Q_VAL_);
        frqResp_.SetParams(ck_);
    }

    // 周波数特性の描画
    void GrEqDesignerDrawer::DrawResponse()
    {
        drawerObj_.DrawAxis();              // 目盛線の描画        
        FrqRespDrawer::AxisX_Char numX[] =  // 横軸の目盛値を描画する際に使う構造体の配列
            {{   50,  "50"}, {  100, "100"}, {  200, "200"}, {  500, "500"}, { 1000, "1k"},
             { 2000,  "2k"}, { 5000,  "5k"}, {10000, "10k"}, {20000, "20k"}};

        drawerObj_.DrawNumericX(numX, 9, 6, "Frequency [Hz]");  // 横軸の目盛
        drawerObj_.DrawNumericY(-24, -6, 6, "%3d");             // 縦軸の目盛値は 6 dB 間隔
        drawerObj_.DrawGraph(frqResp_);     // 周波数特性のカーブの描画
    }
    
    // 周波数特性の平坦化と描画
    void GrEqDesignerDrawer::DrawFlat()
    {
        for (int n=0; n<BANDS_; n++)
            ck_[n] = calculator_.Execute(n, f0_[n], 0, Q_VAL_);
        frqResp_.SetParams(ck_);

        drawerObj_.Erase();
        drawerObj_.DrawAxis();              // 目盛線の描画
        drawerObj_.DrawGraph(frqResp_);     // 周波数特性のグラフのカーブを描画する
    }

    // 特定のバンドのイコライザ用フィルタのパラメータの設定と周波数特性の再描画
    void GrEqDesignerDrawer::DesignAndRedraw(float gainDb, int n)
    {
        ck_[n] = calculator_.Execute(n, f0_[n],  gainDb, Q_VAL_);
        frqResp_.SetParam(ck_[n], n);

        drawerObj_.Erase();
        drawerObj_.DrawAxis();              // 目盛線の描画
        drawerObj_.DrawGraph(frqResp_);     // 周波数特性のグラフのカーブを描画する
    }
}
