//----------------------------------------------------------------
//  グラフィックイコライザ付き SD オーディオプレーヤー
//      SD のファイル: *.wav
//                   PCM，16 ビットステレオ，標本化周波数 44.1 kHz
//                   上記以外の形式は扱わない
//      出力：モノラル（L+R，左右チャンネルに出力）
//
//  2017/04/10, Copyright (c) 2017 MIKAMI, Naoki
//----------------------------------------------------------------

#include "GraphicEqualizer.hpp"

using namespace Mikami;

int main()
{
    // フィルタの設計と周波数特性描画用
    GrEqDesignerDrawer drawerObj(
        50,         // グラフの左端の位置
        130,        // グラフの下端の位置
        2.5f,       // 1 dB 当たりのピクセル数
        9,          // バンド数
        62.5f,      // 最低域の周波数特性を決める周波数
        AUDIO_FREQUENCY_44K);    // 標本化周波数

    GraphicEqualizer myPlayer("9-band Graphic Equalizer",
                              drawerObj);
    myPlayer.Execute();
}
