//-----------------------------------------------------------
// SD_BitmapReader クラス（ヘッダ）
//      SD カードの *.bmp ファイルの内容を読み出す
//      ファイルの画素数の最大値：480×272 ピクセル
//      だだし，ファイル名が日本語のものが除く
//
//  2018/10/23, Copyright (c) 2018 MIKAMI, Naoki
//-----------------------------------------------------------

#include "BitmapReader.hpp"

namespace Mikami
{
    SD_BitmapReader::~SD_BitmapReader()
    {
        sd_->unmount();
        delete sd_;
    }

    bool SD_BitmapReader::Open(const string fileName)
    {
        // シフト JIS のコードがあれば false を返す
        for (int n=0; n<fileName.size(); n++)
        {
            uint8_t c = fileName[n];
            if (((c>=0x81) && (c<=0x9f)) || ((c>=0xe0) && (c<=0xfc)))
                return false;
        }

        string name = (string)"/" + STR_ + "/" + fileName;
        fp_ = fopen(name.c_str(), "rb");
        if (fp_ == NULL) ErrorMsg("open error!!");
        
        return true;
    }

    // 条件に合うビットマップ･ファイルかどうか調べる
    //      戻り値：条件に合うビットマップ･ファイルの場合 true
    bool SD_BitmapReader::IsAllowed()
    {
        uint8_t data[54];   // Windows のピットマップ･ファイルのヘッダは 54 ビットに固定
        fread(data, 1, 54, fp_);    // 54 バイト分を読み込む

        // ファイルタイプを調べる
        if ((data[0] != 'B') || (data[1] != 'M')) return false;

        // 画像の幅が許される最大のピクセル数を超えていないか調べる
        if (*(uint32_t *)(data+18) > maxWidth_) return false;

        // 画像の高さが許される最大のピクセル数を超えていないか調べる
        if (*(uint32_t *)(data+22) > maxHeight_) return false;

        return true;
    }
}

