//-----------------------------------------------------------
//  microSD のビットマップファイルを読み込み表示するグローバル関数
//      縦方向に分割して読み込みと描画を行う
//      F746_GUI は Rev.32 を使うこと
//
//  2018/10/21, Copyright (c) 2018 MIKAMI, Naoki
//-----------------------------------------------------------

#include "BitmapReader.hpp"

using namespace Mikami;

void ReadAndDraw(const string fileName, SD_BitmapReader &sdReader,
                 uint8_t bmp[], uint32_t headerSize, int div)
{
    sdReader.Open(fileName);            // ファイルのオープン
    sdReader.ReadFile(bmp, headerSize); // ヘッダの読み込み

    uint32_t height = sdReader.GetHeight(bmp);  // 画像の高さ，単位：ピクセル
    uint32_t h0 = height/div;                   // 分割した画像の高さ，単位：ピクセル
    sdReader.SetHeight(bmp, h0);                // 画像の高さ設定，単位：ピクセル

    uint8_t *ptr = (uint8_t *)(bmp+headerSize); // 画像データのポインタ
    uint32_t size = sdReader.GetSize(bmp)/div;  // 一度で読込む画像データのサイズ計算，単位：バイト

    // 縦方向に分割して読み込みと描画を行う
    for (int n=0; n<div; n++) 
    {
        sdReader.ReadFile(ptr, size);           // 画像データの読み込み
        GuiBase::GetLcd().DrawBitmap(0, (div-1-n)*h0, bmp);
    }

    sdReader.Close();                   // ファイルのクローズ
}
