//--------------------------------------------------------------
//  FileSelector class ---- Header ----
//      SD カード内の *.bmp ファイル名の一覧を表示し，ファイルを選択する
//      だだし，日本語のファイル名は除く
//
//  2018/10/23, Copyright (c) 2018 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef FILE_SELECTOR_HPP
#define FILE_SELECTOR_HPP

#include "F746_GUI.hpp"
#include "BitmapReader.hpp"
#include <algorithm>    // sort() で使用
#include <string>

namespace Mikami
{
    class FileSelector
    {
    public:
        FileSelector(uint8_t x0, uint8_t y0, int maxFiles,
                     int maxNameLength, SD_BitmapReader &reader);

        virtual ~FileSelector();
        
        // ファイルの一覧表を作る．BMP ファイルが存在しない場合は false を返す
        bool CreateTable();

        // ファイルを選択する
        bool Select(string &fileName);

        // ファイルの一覧の表示
        void DisplayFileList(bool sortEnable = true);

        // ファイルの一覧の消去
        void Erase(uint16_t x, uint16_t y, uint16_t width, uint16_t height,
                   uint32_t color = GuiBase::ENUM_BACK);

    private:
        static const int MAX_LIST_PAGE_ = 6;  // 1ページに表示するファイル数の最大値
        static const uint8_t W_H_ = 24;
        static const uint8_t V_L_ = 36;
        static const uint32_t BASE_COLOR_ = 0xFF80FFA0;
        static const uint32_t TOUCHED_COLOR_ = 0xFF80FFFF;
        const uint8_t X_, Y_;
        const int MAX_FILES_;
        const int MAX_NAME_LENGTH_;
        
        Array<string> fileNames_;
        Array<Label *> fileNameLabels_;
        ButtonGroup *rect_;
        ButtonGroup next_;
        Label pageLabel_;
        LCD_DISCO_F746NG &lcd_;
        SD_BitmapReader &sdReader_;
        int page_;      // 現在のページ，最初のページは 1
        int nOld_;      // ページ内で以前選択したファイルのインデックス
        int kOld_;      // 以前選択したファイルのインデックス
        int maxPage_;
        int fileCount_;

        // 拡張子を削除したファイル名を取得
        string GetFileNameNoExt(int n);

        // コピー･コンストラクタとオブジェクトの代入演算子は使用禁止
        FileSelector(const FileSelector&);
        FileSelector& operator=(const FileSelector&);
    };
}
#endif  // FILE_SELECTOR_HPP

