//-----------------------------------------------------------
//  ビットマップ･ファイルのビュアー
//  microSD のビットマップ･ファイルを読み込み表示する
//      F746_GUI は Rev.32 を使うこと
//      BSP_DISCO_F746NG は Rev.5 を使うこと
//      Mbed の公式ライブラリ： mbed_src_STM32F7
//
//      扱うビットマップ･ファイルの最大ピクセル数
//          縦： 272 ピクセル，横： 480 ピクセル
//      縦方向のピクセル数の制約：8 の倍数にすること
//
//  2018/10/23, Copyright (c) 2018 MIKAMI, Naoki
//-----------------------------------------------------------

#include "ReadAndDisplay.hpp"
#include "FileSelectorBmp.hpp"
#include "Label.hpp"
#include "Button.hpp"

using namespace Mikami;

int main()
{
    const uint32_t WIDTH_MAX = 480;         // 横方向のビット数（最大値）
    const uint32_t HEIGHT_MAX = 272;        // 縦方向のビット数（最大値）
    const uint32_t DIV = 8;                 // 縦方向の分割数
    const uint32_t SIZE= 3*WIDTH_MAX*HEIGHT_MAX/DIV;
    const uint32_t HEADER_SIZE = 54;        // ヘッダのサイズ（固定）

    static uint8_t bmp[SIZE+HEADER_SIZE];   // 作業領域（static は必須）

    Label label1(240,  20, "Bitmap File Viewer", Label::CENTER, Font24);
    Label label2(120,  70, "Maximum Size", Label::LEFT, Font16);
    Label label3(150,  94, "Width:  480 pixels", Label::LEFT, Font16);
    Label label4(150, 114, "Height: 272 pixels", Label::LEFT, Font16);
    Label label5(120, 134, "Height must be multiple of 8.", Label::LEFT, Font16);    
    Label labelC(470, 260, "(C) MIKAMI, Naoi, 2018", Label::RIGHT, Font12);
    Label labelT(120, 160, Label::LEFT, Font16, LCD_COLOR_RED);
    
    Button startButton(200, 200, 80, 40, "START");
    while (!startButton.Touched()) {}   // ボタンがタップされるまで待つ
    wait(0.2);
    
    SD_BitmapReader sdReader(WIDTH_MAX, HEIGHT_MAX);
    FileSelector selecter(60, 12, 256, 37, sdReader);
    
    // SD カードにビットマップ･ファイルが存在しない場合は，SD カードを入れ替えてから
    // 画面をタップすると最初からやり直す
    if (!selecter.CreateTable())
    {
        labelT.Draw("No bitmap files.");
        while (!GuiBase::PanelTouched()) {}
        wait(0.2);
        NVIC_SystemReset();     // マイコンのリセット
    }

    while (true)
    {
        selecter.DisplayFileList();             // ファイルのリストを表示する

        string fileName;
        while (!selecter.Select(fileName)) {}   // ファイルが選択されるまで待つ
        GuiBase::GetLcd().Clear(GuiBase::ENUM_BACK);    // 画面のクリア

        // 選択されたビットマップ･ファイルを読み込み，表示する
        ReadAndDraw(fileName, sdReader, bmp, HEADER_SIZE, DIV);
        wait(0.5);

        // 画面がタップされるまで待つ
        while (!GuiBase::PanelTouched()) {}
        wait(0.1);
    }
}
