//---------------------------------------------------------------
//  トリガの条件を満足したデータを表示用データ領域の先頭から順に転送する
//      トリガ条件は左右両チャンネルでチェックし，先に条件を
//      満足した点をトリガポイントとする
//
//  2016/07/23, Copyright (c) 2016 MIKAMI, Naoki
//---------------------------------------------------------------

#ifndef F746_TRIGGER_HPP
#define F746_TRIGGER_HPP

#include "mbed.h"
#include "Array.hpp"
#include <algorithm>    // min(), max() で使う

namespace Mikami
{
    class Trigger
    {
    public:
        Trigger(const Array<int16_t>& snL,  // 元のデータ，左チャンネル
                const Array<int16_t>& snR,  // 元のデータ，右チャンネル
                Array<int16_t>& xnL,        // 表示用データ，左チャンネル
                Array<int16_t>& xnR,        // 表示用データ，右チャンネル
                int threshold )             // トリガの基準値
            : snL_(snL), snR_(snR), xnL_(xnL), xnR_(xnR),
              TH_(threshold), N_SEARCH_(snL.Length()/3) {}

        bool Execute()
        {
            int nL = Search(snL_);
            int nR = Search(snR_);
            int nStart = min(nL, nR);

            for (int n=0; n<xnL_.Length(); n++)
            {
                int nS = n + nStart;
                xnL_[n] = snL_[nS];
                xnR_[n] = snR_[nS];
            }
            
            return nStart < N_SEARCH_;
        }

    private:
        const Array<int16_t> &snL_, &snR_;
        Array<int16_t> &xnL_, &xnR_;
        const int TH_;
        const int N_SEARCH_;
        
        int Search(const Array<int16_t>& un)
        {
            int n;
            for (n=1; n<N_SEARCH_; n++)
                if ((un[n-1] < -TH_) && (un[n] > TH_))
                    break;
            return n;
        }
    };
}
#endif  // F746_TRIGGER_HPP
