//-----------------------------------------------------------
//  Class for waveform display ---- Header
//
//  2017/03/17, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef F746_WAVEFORM_DISPLAY_HPP
#define F746_WAVEFORM_DISPLAY_HPP

#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "Array.hpp"

namespace Mikami
{
    class WaveformDisplay
    {
    public:
        WaveformDisplay(LCD_DISCO_F746NG &lcd,
                        uint16_t x0, uint16_t y0,
                        const Array<int16_t>& xn,
                        uint16_t rShift,
                        uint32_t axisColor,
                        uint32_t lineColor,
                        uint32_t backColor)
            : X0_(x0), Y0_(y0), xn_(xn),
              N_DATA_(xn.Length()),
              R_SHIFT_(rShift),
              AXIS_COLOR_(axisColor),
              LINE_COLOR_(lineColor),
              BACK_COLOR_(backColor),
              lcd_(lcd) { Axis(); }
        
        void Execute();
        
    private:
        const uint16_t X0_, Y0_;
        const Array<int16_t>& xn_;
        const int N_DATA_;
        const uint16_t R_SHIFT_;
        const uint32_t AXIS_COLOR_;
        const uint32_t LINE_COLOR_;
        const uint32_t BACK_COLOR_;
        static const int LIMIT_ = 32;
        static const int LIMIT2_ = LIMIT_ + 1;

        LCD_DISCO_F746NG &lcd_;
        
        // Clipping
        uint16_t Clip(int16_t xn);
        
        void Axis();

        // disallow copy constructor and assignment operator
        WaveformDisplay(const WaveformDisplay& );
        WaveformDisplay& operator=(const WaveformDisplay& );
    };
}
#endif  // F746_WAVEFORM_DISPLAY_HPP
