//-----------------------------------------------------------
//  Class for waveform display
//
//  2017/03/17, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#include "WaveformDisplay.hpp"

namespace Mikami
{
    void WaveformDisplay::Execute()
    {
        uint16_t lim1 = Y0_ + LIMIT2_;
        uint16_t lim2 = Y0_ - LIMIT2_;
        Axis();
        lcd_.SetTextColor(LINE_COLOR_);
        uint16_t x1 = X0_;
        uint16_t y1 = Clip(xn_[0]);
        for (int n=1; n<N_DATA_; n++)
        {
            uint16_t x2 = X0_ + n;
            uint16_t y2 = Clip(xn_[n]);
            if ( ((y2 == lim1) && (y1 == lim1)) ||
                 ((y2 == lim2) && (y1 == lim2)) )
            {   // Out of displaying boundaries
                lcd_.SetTextColor(LCD_COLOR_RED);
                lcd_.DrawHLine(x1, y1, 1);
                lcd_.SetTextColor(LINE_COLOR_);
            }
            else
                lcd_.DrawLine(x1, y1, x2, y2);
            if ((y1 == lim1) || (y1 == lim2))
                lcd_.DrawPixel(x1, y1, LCD_COLOR_RED);
            x1 = x2;
            y1 = y2;
        }
        lcd_.SetTextColor(BACK_COLOR_);
    }
        
    // Clipping
    uint16_t WaveformDisplay::Clip(int16_t xn)
    {
        int16_t x = xn >> R_SHIFT_;
        if (x >  LIMIT_ ) x =  LIMIT2_;
        if (x < -LIMIT_ ) x = -LIMIT2_ ;
        return Y0_ - x;
    }

    void WaveformDisplay::Axis()
    {
        lcd_.SetTextColor(BACK_COLOR_);
        lcd_.FillRect(X0_, Y0_-LIMIT2_, N_DATA_, LIMIT2_*2+1);

        lcd_.SetTextColor(AXIS_COLOR_);
        lcd_.DrawLine(X0_-5, Y0_, X0_+N_DATA_+5, Y0_);
    }        
}
