//-------------------------------------------------------
//  Functions for audio device on DISCO-F746NG and etc.
//  2016/01/06, Copyright (c) 2016 MIKAMI, Naoki
//-------------------------------------------------------

#include "main.h"
#include "functions_for_audio.hpp"

// Initialize audio input and run 
//      InputDevice: INPUT_DEVICE_DIGITAL_MICROPHONE_2 or INPUT_DEVICE_INPUT_LINE_1
void InitRunAudioIn(uint16_t inputDevice, int samplingFreq)
{
    init_audio_in(inputDevice, samplingFreq);
    record_audio_in();
}

// Stop audio input
void StopAudioIn()
{
    if (BSP_AUDIO_IN_Stop(CODEC_PDWN_SW) == AUDIO_ERROR)
        error_trap();    
}

// Defined in BSP_overwrite.cpp by Nanase
void AUDIO_IN_SAIx_DMAx_IRQHandler();

// Initialize audio-in for DISCO-F746NG
static void init_audio_in(uint16_t InputDevice, int SamplingFreq)
{
    int audioInVolume = (InputDevice == INPUT_DEVICE_INPUT_LINE_1) ? 86 : 100;

    if (BSP_AUDIO_IN_Init(InputDevice, audioInVolume, SamplingFreq) == AUDIO_ERROR)
            error_trap();
    NVIC_SetVector(AUDIO_IN_SAIx_DMAx_IRQ, (uint32_t)AUDIO_IN_SAIx_DMAx_IRQHandler);
}

// Start sampling of audio input signal
static void record_audio_in()
{
    if (BSP_AUDIO_IN_Record((uint16_t*)audio_in_buffer, BufferSize) == AUDIO_ERROR)
        error_trap();
}

void error_trap()
{
    DigitalOut led1(LED1);
    fprintf(stderr, "\r\n### ERROR\r\n");
    while(true)
    {
        led1 = !led1;
        wait_ms(250);
    }
}

// Decimator by a factor of 2 using 3-tap FIR filter
//      This function is used for downsampling 16 kHz to 8 kHz
namespace Mikami
{
    void Decimate(int dataNum, int index, const int16_t xn[], int16_t yn[])
    {
        static const float h0 = 5.443840E-01f;
        static const float h1 = 2.928932E-01f;

        for (int n=0; n<dataNum; n++)
        {
            // Execute FIR filter with 3 taps
            yn[n] = h0*xn[index+2] + h1*(xn[index] + xn[index+4]);
            
            index += 4; // Corresponding to decimation by a factor of 2
        }
    }   
}
