//-------------------------------------------------------
//  Class for display spectrum (Header)
//
//  2016/01/07, Copyright (c) 2015 MIKAMI, Naoki
//-------------------------------------------------------

#ifndef SPECTRUM_DISPLAY_HPP
#define SPECTRUM_DISPLAY_HPP

#include "LCD_DISCO_F746NG.h"

namespace Mikami
{
    class SpectrumDisplay
    {
    public:
        SpectrumDisplay(LCD_DISCO_F746NG &lcd,
                        int nFft, int x0, int y0, float offset,
                        float db1, int bin, float maxDb, int fs,
                        uint32_t axisColor, uint32_t lineColor,
                        uint32_t backColor);
        void Draw(float db[]);
        void Clear();

    private:

        const int N_FFT_;       // number of date for FFT
        const int X0_;          // Origin for x axis
        const int Y0_;          // Origin for y axis
        const float OFFSET_;    // Offset for display
        const float DB1_;       // Pixels for 1 dB
        const int BIN_;         // Pixels per bin
        const float MAX_DB_;    // Maximum dB
        const int FS_;          // Sampling frequency: 10 kHz
        const uint32_t AXIS_COLOR_;
        const uint32_t LINE_COLOR_;
        const uint32_t BACK_COLOR_;

        LCD_DISCO_F746NG& lcd_;

        void AxisX();       // x-axis
        void AxisY();       // y-axis
        
        void DrawString(uint16_t x, uint16_t y, char str[])
        {  lcd_.DisplayStringAt(x, y, (uint8_t *)str, LEFT_MODE); }

        // disallow copy constructor and assignment operator
        SpectrumDisplay(const SpectrumDisplay& );
        SpectrumDisplay& operator=(const SpectrumDisplay& );
    };
}
#endif  // SPECTRUM_DISPLAY_HPP
