//-------------------------------------------------------
//  Class for spectrum analysis using linear prediction
//
//  2015/12/15, Copyright (c) 2015 MIKAMI, Naoki
//-------------------------------------------------------

#include "LPC_Analysis.hpp"

namespace Mikami
{
    LpcAnalyzer::LpcAnalyzer(int nData, int nFft, int order)
        : AnalyzerBase(nData, nFft, nData-1), ORDER_(order),
          lp_(nData-1, order), an_(new float[order]),
          xFft_(new float[nFft]), yFft_(new Complex[nFft/2+1]) {}

    LpcAnalyzer::~LpcAnalyzer()
    {
        delete[] an_;
        delete[] xFft_;
        delete[] yFft_;
    }

    void LpcAnalyzer::Analyze(const float xn[], float yn[])
    {
        float em;
        lp_.Execute(xn, an_, em);

        // To spectrum
        xFft_[0] = 1.0f;
        for (int n=0; n<ORDER_; n++) xFft_[n+1] = -an_[n];
        for (int n=ORDER_+1; n<N_FFT_; n++) xFft_[n] = 0.0f;
        fft_.Execute(xFft_, yFft_); // execute FFT

        // Translate to dB
        for (int n=0; n<=N_FFT_/2; n++)
            yn[n] = 10.0f*log10f(em/Norm(yFft_[n]));
    }
}
