//-------------------------------------------------------
//  Class for spectrum analysis using cepstrum (Header)
//
//  2015/12/15, Copyright (c) 2015 MIKAMI, Naoki
//-------------------------------------------------------

#ifndef CEPSTRUM_ANALYZER_HPP
#define CEPSTRUM_ANALYZER_HPP

#include "AnalysisBase.hpp"


namespace Mikami
{
    class CepstrumAnalyzer : public AnalyzerBase
    {
    public:
        CepstrumAnalyzer(int nData, int nFft, int nLifter);
        virtual ~CepstrumAnalyzer();

    private:
        const int N_LIFTER_;

        Complex* yFft_;     // output of FFT
        float* lifter_;     // lifter
        Complex* db_;       // real part: log spectrun
        float* cep_;        // cepstrum
        float* cepLft_;     // liftered cepstrum
        Complex* cepFt_;    // smoothed spectrum

        virtual void Analyze(const float xn[], float yn[]);

        // disallow copy constructor and assignment operator
        CepstrumAnalyzer(const CepstrumAnalyzer& );
        CepstrumAnalyzer& operator=(const CepstrumAnalyzer& );
    };
}
#endif  // CEPSTRUM_ANALYZER_HPP

