//-------------------------------------------------------
//  Class for selecting spectrum analysis method and
//  displaying
//
//  2015/12/29, Copyright (c) 2015 MIKAMI, Naoki
//-------------------------------------------------------

#include "SpectrumDisplay.hpp"
#include "FFT_Analysis.hpp"
#include "LPC_Analysis.hpp"
#include "CepstrumAnalysis.hpp"
using namespace Mikami;

namespace Mikami
{
    class Selector
    {
    public:
        Selector(SpectrumDisplay& disp,
                 int nData, int nFft, int order, int nLifter)
            : disp_(disp), N_DATA_(nData),
              sn_f_(new float[nData]), dbData_(new float[nFft/2+1])
        {
            obj_[0] = new FftAnalyzer(nData, nFft);
            obj_[1] = new LpcAnalyzer(nData, nFft, order);
            obj_[2] = new CepstrumAnalyzer(nData, nFft, nLifter);
        }

        ~Selector()
        {
            delete[] sn_f_;
            delete[] dbData_;
            for (int n=0; n<3; n++) delete obj_[n];
        }

        void Execute(const int16_t sn[], int touchedNum)
        {
            if (touchedNum >=0)
            {
                for (int n=0; n<N_DATA_; n++) sn_f_[n] = sn[n];
                obj_[touchedNum]->Execute(sn_f_, dbData_);
                disp_.Draw(dbData_);
            }
        }

    private:
        SpectrumDisplay& disp_;
        AnalyzerBase* obj_[3];
                
        const int N_DATA_;
        
        float* sn_f_;
        float* dbData_;
    
        // disallow copy constructor and assignment operator
        Selector(const Selector& );
        Selector& operator=(const Selector& );
    };
}
