//-------------------------------------------------------
//  Base class for spectrum analysis
//
//  2015/12/15, Copyright (c) 2015 MIKAMI, Naoki
//-------------------------------------------------------

#include "AnalysisBase.hpp"

namespace Mikami
{
    AnalyzerBase::AnalyzerBase(int nData, int nFft, int nUse)
        : N_DATA_(nData), N_FFT_(nFft),
          fft_(nFft), wHm_(nData-1, nUse),
          xData_(new float[nUse]), wData_(new float[nUse]) {}

    AnalyzerBase::~AnalyzerBase()
    {
        delete[] xData_;
    }

    void AnalyzerBase::Execute(const float xn[], float db[])
    {
        // Differencing
        for (int n=0; n<N_DATA_-1; n++)
            xData_[n] = xn[n+1] - xn[n];
            
        // Windowing (FFT, cepstrum: + zero-padding)
        wHm_.Execute(xData_, wData_);
            
        // Pure virtual function for analyzing
        Analyze(wData_, db);
    }
}

