//-----------------------------------------------------------
//  Class for waveform display
//
//  2015/12/15, Copyright (c) 2015 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef F746_WAVEFORM_DISPLAY_HPP
#define F746_WAVEFORM_DISPLAY_HPP

#include "mbed.h"

namespace Mikami
{
    class WaveformDisplay
    {
    public:
        WaveformDisplay(LCD_DISCO_F746NG &lcd,
                        uint16_t x0, uint16_t y0, int nData,
                        uint16_t rShift,
                        uint32_t axisColor, uint32_t lineColor,
                        uint32_t backColor)
            : X0_(x0), Y0_(y0), N_DATA_(nData), R_SHIFT_(rShift),
              AXIS_COLOR_(axisColor), LINE_COLOR_(lineColor),
              BACK_COLOR_(backColor), lcd_(lcd) { Axis(); }
        
        void Execute(const int16_t xn[])
        {
            Axis();
            lcd_.SetTextColor(LINE_COLOR_);
            uint16_t x1 = X0_;
            uint16_t y1 = Y0_ - (xn[0] >> R_SHIFT_);
            for (int n=1; n<N_DATA_; n++)
            {
                uint16_t x2 = X0_ + n;
                uint16_t y2 = Y0_ - (xn[n] >> R_SHIFT_);
                lcd_.DrawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }       
        }
        
    private:
        const uint16_t X0_;
        const uint16_t Y0_;
        const int N_DATA_;
        const uint16_t R_SHIFT_;
        const uint32_t AXIS_COLOR_;
        const uint32_t LINE_COLOR_;
        const uint32_t BACK_COLOR_;

        LCD_DISCO_F746NG& lcd_;
        
        void Axis()
        {
            lcd_.SetTextColor(BACK_COLOR_);
            lcd_.FillRect(X0_, Y0_-36, N_DATA_, 72);

            lcd_.SetTextColor(AXIS_COLOR_);
            lcd_.DrawLine(X0_-5, Y0_, X0_+N_DATA_+5, Y0_);
        }        

        // disallow copy constructor and assignment operator
        WaveformDisplay(const WaveformDisplay& );
        WaveformDisplay& operator=(const WaveformDisplay& );
    };
}
#endif  // F746_WAVEFORM_DISPLAY_HPP
