//------------------------------------------------
//  Class for sampling input signal (Header)
//
//  2015/12/31, Copyright (c) 2015 MIKAMI, Naoki
//------------------------------------------------

#ifndef F746_SAMPLER_HPP
#define F746_SAMPLER_HPP

#include "mbed.h"

namespace Mikami
{
    class Sampler
    {
    public:
        Sampler(PinName pin, int fs, int nData);
                
        ~Sampler();

        // Start sampling
        void Start(bool onOff);
        
        // Stop sampling
        void Stop() { timer_.detach(); }

        bool Filled() { return filled_; }

        // Get pointer for sampled data
        int16_t* Get() { return sn_; }

    private:
        const int TS_;      // sampling period
        const int N_DATA_;  // number of 1 frame data

        AnalogIn aIn_;      // Object for ADC
        Ticker timer_;      // Object of Ticker

        bool trigger_;
        bool filled_;
        int count_;
        int16_t xnM1_;
        int16_t* const sn_;     // data to be analyzed
        int16_t* const buffer_; // for input buffer

        // For input
        int16_t (Sampler::*Rd)();
        int16_t ReadNorm() { return aIn_.read_u16() - 32767; }
        int16_t ReadInv()  { return 32767 - aIn_.read_u16(); }

        // Set inverting on or off
        void Invert(bool onOff)
        {
            Rd = onOff ?
                 &Sampler::ReadInv      // Inverted
               : &Sampler::ReadNorm;    // Non-inverted
        }
        
        // Interrupt service routine for Ticker
        void Isr();

        // disallow copy constructor and assignment operator
        Sampler(const Sampler& );
        Sampler& operator=(const Sampler& );
    };
}
#endif  // F746_SAMPLER_HPP
