//-----------------------------------------------------------
//  Class for sampling input signal
//
//  2015/12/28, Copyright (c) 2015 MIKAMI, Naoki
//-----------------------------------------------------------

#include "Sampler.hpp"

namespace Mikami
{
    Sampler::Sampler(PinName pin, int fs, int nData)
        : TS_(1000000/fs), N_DATA_(nData), aIn_(pin),
          sn_(new int16_t[nData]),
          buffer_(new int16_t[nData])
    {
        for (int n=0; n<nData; n++) sn_[n] = 32767;
    }

    Sampler::~Sampler()
    {
        delete[] sn_;
        delete[] buffer_;
    }

    // Start sampling
    void Sampler::Start(bool onOff)
    {
        count_ = 0;
        filled_ = false;
        trigger_ = false;
        xnM1_ = 32767;
        Invert(onOff);
        timer_.attach_us(this, &Sampler::Isr, TS_);
    }

    // Interrupt service routine for Ticker
    void Sampler::Isr()
    {
        int16_t xn = (this->*Rd)(); // Read from A0
        if (!trigger_)
        {
            // Detect rising edge
            if ((xn > (xnM1_+512)) && (xn > 2048))
                trigger_ = true;
            else
                xnM1_ = xn;
            return;
        }
        else
            buffer_[count_] = xn;   

        if (++count_ >= N_DATA_)
        {
            timer_.detach();
            memcpy(sn_, buffer_, N_DATA_*sizeof(int16_t));
            filled_ = true; // Permits spectrum analysis
        }
    }
}
