//-----------------------------------------------------
//  Class for linear prediction (Header)
//
//  2015/12/15, Copyright (c) 2015 MIKAMI, Naoki
//-----------------------------------------------------

#ifndef LINEAR_PREDICTION_HPP
#define LINEAR_PREDICTION_HPP

#include "mbed.h"

namespace Mikami
{
    class LinearPred
    {
    public:
        LinearPred(int nData, int order);
        ~LinearPred();
        bool Execute(const float x[], float a[], float &em);
    private:
        const uint16_t N_DATA_;
        const uint16_t ORDER_;

        float* r_;  // for auto-correlation
        float* k_;  // for PARCOR coefficients
        float* am_; // working area

        void AutoCorr(const float x[]);
        bool Durbin(float a[], float &em);

        // disallow copy constructor and assignment operator
        LinearPred(const LinearPred& );
        LinearPred& operator=(const LinearPred& );
    };
}
#endif  // LINEAR_PREDICTION_HPP
