//---------------------------------------------------------------
//  Class for spectrum analysis using linear prediction (Header)
//
//  2015/12/15, Copyright (c) 2015 MIKAMI, Naoki
//---------------------------------------------------------------

#ifndef LPC_ANALYZER_HPP
#define LPC_ANALYZER_HPP

#include "AnalysisBase.hpp"
#include "LinearPrediction.hpp"

namespace Mikami
{
    class LpcAnalyzer : public AnalyzerBase
    {
    public:
        LpcAnalyzer(int nData, int nFft, int order);
        virtual ~LpcAnalyzer();
        
    private:
        const int ORDER_;

        LinearPred lp_;

        float* an_;     // predictor coefficient 
        float* xFft_;   // input for FFT
        Complex* yFft_; // output of FFT

        virtual void Analyze(const float xn[], float yn[]);

        // disallow copy constructor and assignment operator
        LpcAnalyzer(const LpcAnalyzer& );
        LpcAnalyzer& operator=(const LpcAnalyzer& );
    };
}
#endif  // LPC_ANALYZER_HPP
