//--------------------------------------------------------------
//  可変フィルタ処理付き SD オーディオプレーヤー
//      SD のファイル: *.wav
//                   PCM，16 ビットステレオ，標本化周波数 44.1 kHz
//      可変フィルタ ---- IIR 低域通過および高域通過フィルタ
//      出力：モノラル（L+R を左右チャンネルに出力する）
//
//  2017/04/13, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef F746_SD_VARIABLE_IIR_FILTER_MAIN
#define F746_SD_VARIABLE_IIR_FILTER_MAIN

#include "VariableIirFilter.hpp"

using namespace Mikami;

void VariableIirFilterMain()
{
    const int FS = AUDIO_FREQUENCY_44K; // 標本化周波数

    // フィルタの設計と周波数特性描画用
    BtwthDesignerDrawer drawerObj(
        55,     // グラフの左端の位置
        230,    // グラフの下端の位置
        3,      // 1 dB 当たりのピクセル数
        FS,     // 標本化周波数
        6,      // フィルタの次数
        400,    // 最初に与える遮断周波数
        200,    // 遮断周波数の最小値
        10000,  // 遮断周波数の最大値
        BilinearDesign::LPF);  // 低域通過フィルタ
        
    VariableIirFilter myPlayer("Variable LPF and HPF", drawerObj);
    myPlayer.Execute(); // SD_PlayerSkeleton のメンバ関数
}
#endif  // F746_SD_VARIABLE_IIR_FILTER_MAIN

