//--------------------------------------------------------------
// Base class for Reverb unit
//  2017/04/04, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef REVERB_UNIT_BASE_HPP
#define REVERB_UNIT_BASE_HPP

#include "mbed.h"
#include "Array.hpp"

namespace Mikami
{
    // Base class for reverb unit
    class ReverbBase
    {
    public:
        // Constructor
        ReverbBase(int delay)
            : ptr_(0), delay_(delay), un_(delay)
        {   Clear(); }

        // Clear internal delay elements
        void Clear()
        {   for (int n=0; n<delay_; n++) un_[n] = 0; }

    protected:
        float Get() { return un_[ptr_]; }

        float Get(int n)
        {
            int k = ptr_ + n;
            if (k > delay_) k -= delay_;
            if (k < 0) k += delay_;
            return un_[k];
        }

        void Set(float x)
        {
            un_[ptr_] = x;   
            if (++ptr_ >=  delay_) ptr_ = 0;
        }

    private:
        int ptr_;
        int delay_;
        Array<float> un_;   // for delay

        // disallow copy constructor and assignment operator
        ReverbBase(const ReverbBase&);
        ReverbBase& operator=(const ReverbBase&);
    };
}
#endif  // REVERB_UNIT_BASE_HPP
