//-----------------------------------------------------------
//  Frequency response for IIR filter of cascade form
//
//  2017/03/28, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef IIR_CASCADE_FREQUENCY_RESPONSE_HPP
#define IIR_CASCADE_FREQUENCY_RESPONSE_HPP

#include "FrequancyResponseBase.hpp"
#include "Biquad.hpp"

namespace Mikami
{
    class IIR_CascadeFrqResp : public FrequencyResponse
    {
    public:
        IIR_CascadeFrqResp() {}

        // 次数とフィルタの係数設定
        void SetParams(int order, float g0, Biquad::Coefs ck[])
        {
            order_ = order;
            g0_ = g0;
            ck_ = ck;
        }

        // 周波数応答の絶対値を返す関数, 引数: z^(-1)
        virtual float AbsH_z(Complex u)
        {
            Complex h = g0_;
            for (int k=0; k<order_/2; k++)
                h = h*(1.0f + (ck_[k].b1 + ck_[k].b2*u)*u)
                     /(1.0f - (ck_[k].a1 + ck_[k].a2*u)*u);
            return abs(h);       
        }
        
    private:
        int order_;
        float g0_;
        Biquad::Coefs *ck_;

        // disallow copy constructor and assignment operator
        IIR_CascadeFrqResp(const IIR_CascadeFrqResp&);
        IIR_CascadeFrqResp& operator=(const IIR_CascadeFrqResp&);
    };
}
#endif  // IIR_CASCADE_FREQUENCY_RESPONSE_HPP