//------------------------------------------------------------------------------
//  IIR フィルタを双１次 z 変換で設計し，その周波数特性を描画するためのクラス -- Header
//      使うフィルタ：Butterworth 特性の LPF と HPF
//  
//  2017/03/16, Copyright (c) 2017 MIKAMI, Naoki
//------------------------------------------------------------------------------

#ifndef F746_BTWTH_DISIGNER_AND_DRAWER_HPP
#define F746_BTWTH_DISIGNER_AND_DRAWER_HPP

#include "NumericLabel.hpp"
#include "TouchPanelDetectorX.hpp"
#include "FrquencyResponseDrawer.hpp"
#include "BilinearDesignLH.hpp"
#include "IIR_CascadeFrqResp.hpp"

namespace Mikami
{
    class BtwthDesignerDrawer
    {
    public:
        // Constructor
        BtwthDesignerDrawer(uint16_t x0, uint16_t y0,
                            float db1, int fs, int order,
                            float fc, uint16_t fL, uint16_t fH,
                            BilinearDesign::Type lpHp);

        virtual ~BtwthDesignerDrawer() {};

        // フィルタの再設計と周波数特性の再描画
        bool ReDesignAndDraw(Biquad::Coefs ck[], float &g0,
                             BilinearDesign::Type lpHp);
        
        // 周波数特性の描画
        void DrawResponse();

        void GetCoefficients(Biquad::Coefs ck[], float &g0);
        
        uint16_t GetOrder() { return ORDER_; }

    private:
        LCD_DISCO_F746NG &lcd_;

        const uint16_t X0_, Y0_;
        const uint16_t ORDER_;
        const uint16_t CURSOR_Y0_, CURSOR_LENGTH_;
        const uint16_t MIN_F_, MAX_F_;
        const uint32_t CURSOR_COLOR_, CURSOR_TOUCHED_COLOR_;

        IIR_CascadeFrqResp frqResp_;    // IIR フィルタの周波数応答に対応するオブジェクト
        Array<BilinearDesign::Coefs> coefs_;    // 設計された係数
        Array<Biquad::Coefs> &ck_;
        float g0_;                      // 設計された係数(利得定数)
        
        int fC_;    // 遮断周波数

        uint16_t cursorX_, oldCursorX_;
        bool cursorRedraw_;
        BilinearDesign::Type lp_;
        
        FrqRespDrawer drawerObj_;
        BilinearDesign designObj_;
        TouchPanelDetectorX tp_;
        NumericLabel<int> lblFrq_; // 遮断周波数表示用
        
        // 周波数を 10, 20, 50, 100 Hz の倍数にする
        int Frq10(float f);
    };
}
#endif  // F746_BTWTH_DISIGNER_AND_DRAWER_HPP
