//--------------------------------------------------------------
//  信号処理の種類に応じた GUI 部品の状態を変更する
//
//  2017/04/08, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef GUI_CHANGER_HPP
#define GUI_CHANGER_HPP

// Through の場合
void SetThrough(SeekBar *barReverb, SeekBar *barFqCh,
                NumericLabel<int> *frqLabel)
{
    barReverb->Inactivate();
    barFqCh->Inactivate();
    frqLabel->Redraw(GuiBase::ENUM_INACTIVE_TEXT);
}

// 残響生成の場合
void SetReverb(SeekBar *barReverb, SeekBar *barFqCh,
               NumericLabel<int> *frqLabel)
{
    barReverb->Activate();
    barFqCh->Inactivate();
    frqLabel->Redraw(GuiBase::ENUM_INACTIVE_TEXT);
}

// 周波数シフトの場合
void SetFrqShifter(SeekBar *barReverb, SeekBar *barFqCh,
                   NumericLabel<int> *frqLabel)
{
    barReverb->Inactivate();
    barFqCh->Activate();
    frqLabel->Redraw(GuiBase::ENUM_TEXT);
}

#endif  // GUI_CHANGER_HPP
