//-------------------------------------------------------
//  Base abstract class for spectrum analysis (Header)
//
//  2017/03/30, Copyright (c) 2017 MIKAMI, Naoki
//-------------------------------------------------------

#ifndef BASE_ANALYZER_HPP
#define BASE_ANALYZER_HPP

#include "Array.hpp"
#include "fftReal.hpp"
#include "Hamming.hpp"

namespace Mikami
{
    class AnalyzerBase
    {
    public:
        // nData: Number of data to be analyzed
        // nFft:  Number of FFT points
        // nUse:  FFT, cepstrum: window width + zero padding
        //        Linear prediction: window width
        AnalyzerBase(int nData, int nFft, int nUse);
        virtual ~AnalyzerBase() {}
        void Execute(const float xn[], float db[]);

    protected:
        const int N_DATA_;
        const int N_FFT_;

        FftReal fft_;
                
        float Norm(Complex x)
        { return x.real()*x.real() + x.imag()*x.imag(); }

    private:
        HammingWindow wHm_;

        Array<float> xData_;    // data to be analyzed
        Array<float> wData_;    // windowd data

        virtual void Analyze(const float wData[], float db[]) = 0;

        // disallow copy constructor and assignment operator
        AnalyzerBase(const AnalyzerBase& );
        AnalyzerBase& operator=(const AnalyzerBase& );
    };
}
#endif  // BASE_ANALYZER_HPP

