//--------------------------------------------------------------
// Reverb unit: comb filter and all-pass filter
//  2017/04/08, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef REVERB_UNIT_HPP
#define REVERB_UNIT_HPP

#include "ReverbUnitBase.hpp"

namespace Mikami
{
    // Reverb unit using comb filter
    class CombFilter : public ReverbBase
    {
    public:
        // Constructor
        CombFilter(float g, int delay)
            : ReverbBase(delay), G_C_(g) {}

        // Execute comb filter with variable delay
        float Execute(float x, int n)
        {
            float yn = Get(n);
            Set(x + G_C_*yn);
            return yn;
         }

    private:
        const float G_C_;

        // disallow copy constructor and assignment operator
        CombFilter(const CombFilter&);
        CombFilter& operator=(const CombFilter&);
    };

    // Reverb unit using allpass filter
    class AllPassFilter : public ReverbBase
    {
    public:
        // Constructor
        AllPassFilter(float g, int delay)
            : ReverbBase(delay), G_A_(g) {}

        // Execute allpass filter 
        float Execute(float x)
        {
            float un = x + G_A_*Get();
            float yn = -G_A_*un + Get();
            Set(un);
            return yn;
        }

    private:
        const float G_A_;

        // disallow copy constructor and assignment operator
        AllPassFilter(const AllPassFilter&);
        AllPassFilter& operator=(const AllPassFilter&);
    };
}
#endif  // REVERB_UNIT_HPP
