//--------------------------------------------------------------
//  グラフィックイコライザ用のクラス
//  （SD_PlayerSkeleton の派生クラス）
//
//  2017/04/13, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#include "GraphicEqualizer.hpp"

namespace Mikami
{
    GraphicEqualizer::GraphicEqualizer(string str,
                                       GrEqDesignerDrawer &obj)
        : SD_PlayerSkeleton(str, true),     // 第２引数は true にする
          flat_(BG_LEFT_, 197, BG_WIDTH_, BG_HEIGHT_, "FLAT"),
          onOff_(BG_LEFT_, 235, BG_WIDTH_/2, BG_HEIGHT_,
                 2, (string[]){"ON", "OFF"}, 0, 0, 2, 0),
          // 利得の範囲：-8 dB ～ +8 dB
          myBars_(obj.GetX0(), 178, 82,
                  obj.GetBands(), obj.GetSpaceX(),
                  -8.0f, 8.0f, 0, SeekBar::Vertical),
          drawerObj_(obj),
          BANDS_(drawerObj_.GetBands()), hn_(BANDS_)
    {
        // 周波数特性の描画
        drawerObj_.DrawResponse();

        // フィルタの準備
        for (int k=0; k<BANDS_; k++)
            hn_[k] = BiquadGrEq(drawerObj_.GetCoefficient(k));

        on_ = true;
    }

    // １ブロック分の信号処理の実行
    void GraphicEqualizer::SignalProcessing()
    {
        // １ブロック分のステレオデータを SD から読み込みモノラルにする
        sdReader_.ReadAndToMono(sn_);

        while (!mySai_.IsXferred()) {}  // データの転送が終わるまで待つ
        //------------------------------------------------------------
        // １ブロック分のイコライザ処理を行い，その結果を出力する
        for (int n=0; n<BUFF_SIZE_; n++)
        {
            // 縦続形の IIR フィルタ実行
            float xn = 0.125f*sn_[n];   // 0.125 の乗算はブーストしても
                                        // クリップされないようにするため
            float yn = xn;
            for (int k=0; k<BANDS_; k++) yn = hn_[k].Execute(yn);

            int16_t value = on_ ? (int16_t)yn : xn;
            // 音響信号の出力，左右チャンネルに同じものを出力
            mySai_.Output(value, value);
        }
        //------------------------------------------------------------
    }

    // グラフィックイコライザのパラメータ変更
    void GraphicEqualizer::Modefy()
    {
        // 周波数特性を平坦化
        if (flat_.Touched())
        {
            drawerObj_.DrawFlat();
            for (int n=0; n<BANDS_; n++)
                hn_[n] = BiquadGrEq(drawerObj_.GetCoefficient(n));
            myBars_.DrawAll(0);     // ツマミの位置を 0 dB に設定する
            flat_.Draw();
            return;
        }

        // グラフィックイコライザの有効／無効切り替え
        if (onOff_.Touched(0)) on_ = true;
        if (onOff_.Touched(1)) on_ = false;

        static int num = 0;
        if (!myBars_.GetSlidedNumber(num)) return;
        drawerObj_.DesignAndRedraw(myBars_.GetValue(num), num);
        hn_[num] = BiquadGrEq(drawerObj_.GetCoefficient(num));
    }

    // 曲の再生中に表示する
    void GraphicEqualizer::Display()
    {
        myBars_.RedrawAll();
        drawerObj_.DrawResponse();
    }
}
