//----------------------------------------------------------------
//  My リアルタイム サウンド処理マシン
//      1. グラフィックイコライザ付き SD オーディオプレーヤー
//      2. 遮断周波数可変 LPF/HPF 付き SD オーディオプレーヤー
//      3. 残響／ボイスチェンジャ，入力：MEMS マイク
//      4. スペクトログラム，入力：MEMS マイク
//
//  音響出力：モノラル（L+R を左右チャンネルに出力）
//
//  このプログラムで使っている　"BSP_DISCO_F746NG" は，他のライブラリとの
//  関係でコンパイルエラーが発生しないものの中の最新版（rev.5）に更新されて
//  いる．2017/04/14 の時点で rev.6, rev.7, rev.8 ではコンパイルエラーが
//  発生する．
//
//  2017/04/14, Copyright (c) 2017 MIKAMI, Naoki
//----------------------------------------------------------------

#include "GraphicEqulizerMain.hpp"
#include "VariableIirFilterMain.hpp"
#include "ReverbFrShifterMain.hpp"
#include "SpectrogramMain.hpp"

using namespace Mikami;

int main()
{
    Label title(240, 16, "My Realtime Sound Processing Machine",
                Label::CENTER, Font16); 
    const string MENU[] = {"Graphic Equalizer",
                           "Variable LPF/HPF",
                           "Reverb, Voice Changer",
                           "Spectrogram"};
    ButtonGroup menuButtons(
        100, 50, 280, 50, 4, MENU, 0, 5, 1, -1, Font16);

    int num = 0;
    while (!menuButtons.GetTouchedNumber(num)) {}
    menuButtons.EraseAll();
    title.Draw("");
/*
    switch (num)
    {
        case 0: GraphicEqualizerMain();     // グラフィックイコライザ
                break;
        case 1: VariableIirFilterMain();    // 遮断周波数可変 LPF/HPF
                break;
        case 2: ReverbFrShifter();          // 残響生成／周波数変換
                break;
        case 3: Spectrogram();              // スペクトログラム
                break;
    }
*/
    // 以下で実行される関数は，中で無限ループになっているため main() 関数には
    // 戻ってこないので，break 文は不要
    switch (num)
    {
        case 0: GraphicEqualizerMain();     // グラフィックイコライザ
        case 1: VariableIirFilterMain();    // 遮断周波数可変 LPF/HPF
        case 2: ReverbFrShifter();          // 残響生成／周波数変換
        case 3: Spectrogram();              // スペクトログラム
    }
}
