//--------------------------------------------------------------
//  グラフィックイコライザ用のクラス（ヘッダ）
//  （SD_PlayerSkeleton の派生クラス）
//
//  2017/04/10, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef F746_SD_GRAPHIC_EQUALIZER_HPP
#define F746_SD_GRAPHIC_EQUALIZER_HPP

#include "SD_PlayerSkeleton.hpp"
#include "GrEqDesignerDrawer.hpp"
#include "SeekbarGroup.hpp"
#include "BiquadGrEq.hpp"

namespace Mikami
{
    class GraphicEqualizer : public SD_PlayerSkeleton
    {
    public:
        GraphicEqualizer(string str, GrEqDesignerDrawer &obj);
        virtual ~GraphicEqualizer() {};
    
    private:
        Button flat_;
        ButtonGroup onOff_;
        SeekbarGroup myBars_;   // 周波数特性変更用スライダ
        GrEqDesignerDrawer &drawerObj_;

        const int BANDS_;
        Array<BiquadGrEq> hn_;
        bool on_;
        
        // １ブロック分の信号処理の実行
        virtual void SignalProcessing();

        // グラフィックイコライザのパラメータ変更
        virtual void Modefy();

        // 曲の再生中に表示する
        virtual void Display();

        // グラフィックイコライザを構成するフィルタのバッファのクリア
        virtual void Clear()
        {   for (int k=0; k<BANDS_; k++) hn_[k].Clear(); }
    };
}
#endif  // F746_SD_GRAPHIC_EQUALIZER_HPP
