//-------------------------------------------------------------------
//  Hamming windowing with zero-padding
//
//  2017/04/10, Copyright (c) 2017 MIKAMI, Naoki
//-------------------------------------------------------------------

#ifndef HAMMING_WINDOW_HPP
#define HAMMING_WINDOW_HPP

#include "mbed.h"
#include "Array.hpp"

namespace Mikami
{
    class HammingWindow
    {
    public:
        // Constructor
        HammingWindow(uint16_t nData, uint16_t nFft)
                : N_(nData), NFFT_(nFft), w_(nData)
        {
            float pi2L = 6.283185f/(float)nData;
            for (int k=0; k<nData; k++)
                w_[k] = 0.54f - 0.46f*cosf(k*pi2L);
        }

        // Windowing
        void Execute(const float x[], float y[])
        {
            for (int n=0; n<N_; n++) y[n] = x[n]*w_[n];
            for (int n=N_; n<NFFT_; n++) y[n] = 0;
        }

    private:
        const int N_;
        const int NFFT_;

        Array<float> w_;

        // disallow copy constructor and assignment operator
        HammingWindow(const HammingWindow& );
        HammingWindow& operator=(const HammingWindow& );
    };
}
#endif  // HAMMING_WINDOW_HPP
